/* 
 *  CallbackRequestToExternalNumber.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient.request;

import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.api.DestinationI;

public class CallbackRequestToExternalNumber extends InteractionRequest {

    private static final Logger LOG = Logger.getLogger(CallbackRequestToExternalNumber.class);
    private final DestinationI destination;
    private final String externalNumber;
    private final String callbackTime;
    private final String callbackExpiryTime;
    private final String callbackNote;

    public CallbackRequestToExternalNumber(String interactionID, DestinationI destination, String externalNumber, String callbackTime, String callbackExpiryTime, String callbackNote) {
        super(LOG, interactionID);
        this.destination = destination;
        this.externalNumber = externalNumber;
        this.callbackTime = callbackTime;
        this.callbackExpiryTime = callbackExpiryTime;
        this.callbackNote = callbackNote;
    }

    /**
     * The call method executes on the outgoingRequest thread
     *
     * @return
     * @throws Exception
     */
    @Override
    protected Object call() throws Exception {
        String methodName = "call() ";
        LOG.trace(methodName + "+");
        getInteraction().createCallback(destination, externalNumber, callbackTime, callbackExpiryTime, callbackNote);
        LOG.trace(methodName + "-");
        return null;
    }
}
